-- Scene Converter
-- Setup invalid ClassIDs for Physical Renderers workflow
-- the Render Upgrade Assistant is a tool to convert scenes to Physical Renderers, 
-- it can upgrade some of the Objects/Materials/Maps or remove them if they are unsupported.

-- Modify this file at your own risk !

SceneConverter.ClearInvalidclassIDs()

--Invalid Cameras
	--SceneConverter.AddInvalidClassID #eCamera #(0x1001, 0) --Free Camera ClassID
	--SceneConverter.AddInvalidClassID #eCamera #(0x1002, 0) --Target Camera ClassID

--Invalid Lights
	--SceneConverter.AddInvalidClassID #eLight #(0x1011, 0) --Omni Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1012, 0) --Target Spot Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1013, 0) --Target Directional Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1014, 0) --Free Spot Light ClassID
	--SceneConverter.AddInvalidClassID #eLight #(0x1015, 0) --Free Directional Light ClassID
	--SceneConverter.AddInvalidClassID #eLight #(0x7bf61478, 0x522e4705) --Skylight
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		--If the mental ray dll is not present, add its classes as invalid so we can convert or remove them
		SceneConverter.AddInvalidClassID #eLight #(0x0001b669, 0x000875c2) --mental ray Area Spot Light ClassID
		SceneConverter.AddInvalidClassID #eLight #(0x0001b669, 0x000875c1) --mental ray Area Omni Light ClassID
		SceneConverter.AddInvalidClassID #eLight #(0x335c655c, 0x382151b1) --mental ray SkyPortal Light classID
	)

--Invalid Geometries
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eGeometry #(0x2e013bd5, 0x13c00afb) --mental ray Proxy Object ClassID
		SceneConverter.AddInvalidClassID #eGeometry #(0x711f0aad, 0x1c181b09) --mental ray Geometry Object ClassID
		SceneConverter.AddInvalidClassID #eGeometry #(0x64b11409, 0x1e7a186d) --iray Section Planes Object ClassID
	)
	
--Invalid Materials	
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eMaterial #(0x70b05735, 0x4a163654) --mental ray Arch and Design Material ClassID
	)

--Invalid Maps	
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(	
		SceneConverter.AddInvalidClassID #eMap #(0x7773161f, 0x996c7d15L) --mental ray Gamma and Gain	
		SceneConverter.AddInvalidClassID #eMap #(0x628e269e, 0x72386abf) --mental ray Physical sky environment map
	)
	
--Invalid Exposure Control
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eOther #(0x73317331, 0x49154663) --mental ray Photographic Exposure Control
	)
	
--Other
	--SceneConverter.AddInvalidClassID #eOther #(0x4a1e6deb, 0x31c77d57) --Daylight Assembly
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCceNqSOG62fuf10bW/CUMEd99dSpQ2u4z3
-- Gldi2FcUsZ5GNPF+IDDmPP1wlcSAQWKVRNsUAMR6G79nBM4Bmod3TTJVU2aJ64Vs
-- xWNdk46SpxW5Ep839vHVG2JPPzfZLwnu6yT3YjO9SM3RS5UUmQMAcReXb9kwuhKj
-- BzoohnysjzI6TPzmvLvGqAcCewG7i+9rSZq3/DzNhpGhlF8KChWQ0DiRqojeXbxb
-- sMNet4xe2J22bbkPoqIo5nEODIP/CUaNeBMgVvwsFSnF9iX4q5By6dU8GWlgRbVg
-- BIptjkE0ZqgJVyAwB65jvprhMO/o3Peo50jqSSNxKz54LNgMUc4C
-- -----END-SIGNATURE-----